<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2016 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

//default time zone. If set in cms it will overwrite this. If you remove this line the date function will return warnings.
date_default_timezone_set('Europe/Bucharest');

define("STP_GLOBAL_PROTOCOL"				, "https");		// http | https , if empty uses the setting in the cms. Usefull if set the wrong protocol and cant access the cms anymore.

//page title block & module head for all modules
define("STP_PAGEHEADER_NO_WIDTHS"			, "0");		// no width controls 
define("STP_PAGEHEADER_NO_CSS"				, "0");		// no extra css classes for block or elements
define("STP_PAGEHEADER_NO_SUBTITLE"			, "0");		// no subtitle field
define("STP_PAGEHEADER_NO_ALIGN"			, "0");		// no align field
define("STP_PAGEHEADER_NO_SNIPET"			, "0");		// no align field

//widgets module
define("STP_WIDGETS_NO_OPTIONAL_CONTENT"	, "0");		// no optional fields for all widgets ( header / footer / 2 links )

//cms options
define("STP_DISABLE_CATEGORIES"				, "0");		//disabled categories / dropdown support for entire cms
define("STP_DISABLE_MODULE_LAYOUTS"			, "0");		//removes the layouts tab from manage pages
define("STP_SHOW_STATS"						, "0");		//enable to see stats at the bottomom the page ( php executin tiome / queries / used memmory )
define("STP_ENABLE_DEMO"					, "0");		//by activating the following will let anyone enter the cms and see it without loggin in, no operations will be performed over the database in CMS
define("STP_ENABLE_ONEPAGE"					, "0");		//removes certain incompatibilities with onepage so we can keep the same module for onepage and multiplage

define("STP_ENABLE_FULLPAGE"				, "1");		//enables fullpage scroller support in layouts, its not recommanded as its experimental and buggy


//engine settings, 
if ($_ADMIN) {
	define("_3RDPARTY"	 ,"./3rdparty/");			//plugins from other sources
	define("_LIBPATH"	 ,"./lib/");				//framework location
	define("_TPLPATH"	 , "./assets/");			//template and resources for cms interface
	define("_UPLOADPATH" , "../upload/");			//upload folder for public area
} else {
	define("_3RDPARTY"	 ,"./admin/3rdparty/");	
	define("_UPLOADPATH" , "./upload/");

	if (!defined("_LIBPATH")) 
		define("_LIBPATH","./admin/lib/");
	if (!defined("_MODPATH")) 
		define("_MODPATH","./admin/modules/");			
}


$start = memory_get_usage();
$time = microtime(true);



//fix $_GET variables that have . in keys
//https://stackoverflow.com/questions/68651/get-php-to-stop-replacing-characters-in-get-or-post-arrays
function fixGetDots($source) {
    $source = preg_replace_callback(
        '/(^|(?<=&))[^=[&]+/',
        function($key) { return bin2hex(urldecode($key[0])); },
        $source
    );

    parse_str($source, $post);
    return array_combine(array_map('hex2bin', array_keys($post)), $post);
}

//$_GET = fixGetDots($_SERVER['QUERY_STRING']);


//temporary fix for magic quotes
if (function_exists("get_magic_quotes_gpc") && get_magic_quotes_gpc()) {
    $process = array(&$_GET, &$_POST, &$_COOKIE, &$_REQUEST);
    while (list($key, $val) = each($process)) {
        foreach ($val as $k => $v) {
            unset($process[$key][$k]);
            if (is_array($v)) {
                $process[$key][stripslashes($k)] = $v;
                $process[] = &$process[$key][stripslashes($k)];
            } else {
                $process[$key][stripslashes($k)] = stripslashes($v);
            }
        }
    }
    unset($process);
}


//if executed as a wepage load the custom errors handler
if (!defined("CLI")) {
	require_once _LIBPATH . "error/error.php";	
//	error_reporting(E_ERROR | E_WARNING | E_PARSE | E_DEPRECATED);
//	error_reporting(E_ALL);
//	ini_set("display_errors","1");
} else {
	//error_reporting(E_ERROR | E_WARNING | E_PARSE | E_DEPRECATED);
}


global $HTTPS;
if (strtoupper($_SERVER["HTTPS"]) == "ON") {
	$HTTPS = true;
} else {
	$HTTPS = false;
}


// this is suposed to be a bug fix for those IIS servers which doesnt know what
if (!isset($_SERVER["REQUEST_URI"])) {
	$_SERVER["REQUEST_URI"] = 
			($HTTPS ? "https://" :  "http://") . 
			$_SERVER["SERVER_NAME"] . $_SERVER["SCRIPT_NAME"] . 	
			($_SERVER["QUERY_STRING"] ? '?' . $_SERVER["QUERY_STRING"] : '' );
}


require_once _LIBPATH . "site.php";


$site = new CSite(
	($_ADMIN ? "" : "admin/") . "site.xml",
	$_ADMIN , 
	true
);


//activate kcfinder support and pass the paths thru sessions.
if ($_ADMIN) {
	$base_root = $HTTPS ? 'https' : 'http';
	$base_url = $base_root .= '://'. preg_replace('/[^a-z0-9-:._]/i', '', $_SERVER['HTTP_HOST']);
	if ($dir = trim(dirname($_SERVER['SCRIPT_NAME']), '\,/')) {
		$base_path = "/$dir";
		$base_url .= $base_path;
	}

	if ($_ADMIN) {
		$base_url = dirname($base_url);
	}

	$_SESSION['KCFINDER'] = array(
		//activate browser only if logged in 
		'disabled' => is_array($_SESSION["store"]["minibase"]["raw"]) ? false : true,
		'uploadURL' => $base_url,
		'uploadDir' => dirname(__DIR__ . "/") . "/"
	);
}


$site->Run();



$time2 = microtime(true);

function convert($size) {
     $unit=array('b','kb','mb','gb','tb','pb');
     return @round($size/pow(1024,($i=floor(log($size,1024)))),2).' '.$unit[$i];
}


//performance stats
if (STP_SHOW_STATS && ($_PAGE != "ajax") && ($_PAGE != "json") && !$_ADMIN) {

	if (defined("CLI")) {
		echo "\n\n==== SUMMARY ===\n\n";
		echo "PHP Execution Time: " . (($time2 - $time))  . " seconds\n";
		echo "Num Queries: " . $site->db->NumQueries() . "\n";
		echo "Queries Execution Time: " . $site->db->queries_runtime . " seconds\n";
		echo "Memory Usage: " . convert(memory_get_usage() - $start  ) . "\n";
	} else {
		echo "<div style='display: block; height: 100px'><div style='position: fixed; bottom: 0; width: 100%; background: #fff'><center><pre>PHP Execution Time: " . (($time2 - $time))  . " seconds</pre>";
		echo "<pre>Num Queries: " . $site->db->NumQueries() . "</pre>";
		echo "<pre>Queries Execution Time: " . $site->db->queries_runtime . " seconds</pre>";
		echo "<center><pre>Memory Usage: " . convert(memory_get_usage() - $start  ) . "</pre></center></div></div>\n";
	}
}

?>